DECLARE @Versao VARCHAR(4)

SET @Versao = CASE 
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '15' THEN '2019'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '14' THEN '2017'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '13' THEN '2016'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '12' THEN '2014'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '11' THEN '2012'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '10' THEN '2008'
                 WHEN LEFT(CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR), 2) = '09' THEN '2005'
                 ELSE '2000'
              END
			  
IF CONVERT(INT,@Versao) >= 2012
BEGIN

	IF EXISTS (SELECT * FROM sys.objects WHERE  object_id = OBJECT_ID(N'P_CANCELA_MOV_CREDITO_ICMS_ST_PIS_COFINS') AND type IN(N'P', N'PC')
	)
		DROP PROCEDURE P_CANCELA_MOV_CREDITO_ICMS_ST_PIS_COFINS
	END
	GO

	CREATE PROCEDURE P_CANCELA_MOV_CREDITO_ICMS_ST_PIS_COFINS
		@PROT_ICMS_ST_SAIDA INT 
	AS 
	BEGIN
		DECLARE @NovoID INT
		SET @NovoID = NEXT VALUE FOR SequenceProtocoloICMS;

		INSERT INTO EST_NF_ENT_ENTRADA_ICMS_ST_MOV (
			PROT_ICMS_ST,
			CD_EMP,
			CD_FILIAL,
			CD_NF_ENT_CRED,
			TIPO_DOC,
			CD_DOC,
			CD_PROD,
			QT_IT,
			VLR_ICMS_ST_DARE,
			VLR_ICMS_EFETIVO,
			VLR_ICMS_SUBS,
			VLR_ICMS_RET,
			VLR_FECOP,
			VLR_FECOP_RET,
			VLR_FECOP_ST,
			STATUS,
			PROT_ICMS_ST_SAIDA,
			DT_CAD
		)
		SELECT 
			@NovoID
			,CD_EMP
			,CD_FILIAL,
			CD_NF_ENT_CRED,
			TIPO_DOC,
			CD_DOC,
			CD_PROD,
			QT_IT * (-1),
			VLR_ICMS_ST_DARE,
			VLR_ICMS_EFETIVO,
			VLR_ICMS_SUBS,
			VLR_ICMS_RET,
			VLR_FECOP,
			VLR_FECOP_RET,
			VLR_FECOP_ST,
			2,
			PROT_ICMS_ST,
			GETDATE()
		FROM 
			EST_NF_ENT_ENTRADA_ICMS_ST_MOV
		WHERE 
			PROT_ICMS_ST = @PROT_ICMS_ST_SAIDA;
	END
